package org.kodein.emoji.smileys_emotion.face_negative

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithSymbolsOnMouth: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤬",
        description = "face with symbols on mouth",
        unicodeVersion = UnicodeVersion(5, 0),
        aliases = listOf("face-with-symbols-on-mouth", "cursing"),
        emoticons = listOf("#\$@!"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-negative: face with symbols on mouth.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithSymbolsOnMouth: Emoji get() = _FaceWithSymbolsOnMouth

/**
 * Alias to emoji [FaceWithSymbolsOnMouth] (Smileys & Emotion: face-negative: face with symbols on mouth).
*/
public val Emoji.Companion.Cursing: Emoji get() = _FaceWithSymbolsOnMouth
