package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _OkButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🆗",
        description = "OK button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("ok-button", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: OK button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.OkButton: Emoji get() = _OkButton
