package org.kodein.emoji.symbols.punctuation

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteExclamationMark: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "❕",
        description = "white exclamation mark",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("white-exclamation-mark", "exclamation-mark-white"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: punctuation: white exclamation mark.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteExclamationMark: Emoji get() = _WhiteExclamationMark

/**
 * Alias to emoji [WhiteExclamationMark] (Symbols: punctuation: white exclamation mark).
*/
public val Emoji.Companion.ExclamationMarkWhite: Emoji get() = _WhiteExclamationMark
