package org.kodein.emoji.activities.game

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ClubSuit: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "♣️",
        description = "club suit",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("club-suit", "club"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Activities: game: club suit.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ClubSuit: Emoji get() = _ClubSuit

/**
 * Alias to emoji [ClubSuit] (Activities: game: club suit).
*/
public val Emoji.Companion.Club: Emoji get() = _ClubSuit
