package org.kodein.emoji.animals_nature

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.animals_nature.animal_bug.*
import org.kodein.emoji.animals_nature.plant_flower.*
import org.kodein.emoji.animals_nature.animal_marine.*
import org.kodein.emoji.animals_nature.animal_bird.*
import org.kodein.emoji.animals_nature.animal_mammal.*
import org.kodein.emoji.animals_nature.animal_amphibian.*
import org.kodein.emoji.animals_nature.plant_other.*
import org.kodein.emoji.animals_nature.animal_reptile.*


internal fun EmojiFinder.addAllAnimalsNature() {
    addAllAnimalBug()
    addAllPlantFlower()
    addAllAnimalMarine()
    addAllAnimalBird()
    addAllAnimalMammal()
    addAllAnimalAmphibian()
    addAllPlantOther()
    addAllAnimalReptile()
}

internal fun MutableList<Emoji>.addAllAnimalsNature() {
    addAllAnimalBug()
    addAllPlantFlower()
    addAllAnimalMarine()
    addAllAnimalBird()
    addAllAnimalMammal()
    addAllAnimalAmphibian()
    addAllPlantOther()
    addAllAnimalReptile()
}

/**
 * All Emoji of the Animals & Nature group.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allAnimalsNature(): List<Emoji> =
    ArrayList<Emoji>(153).apply { addAllAnimalsNature() }

internal fun allAnimalsNatureSubgroups(): Map<String, () -> List<Emoji>> =
    mapOf(
        "animal_bug" to { Emoji.allAnimalBug() },
        "plant_flower" to { Emoji.allPlantFlower() },
        "animal_marine" to { Emoji.allAnimalMarine() },
        "animal_bird" to { Emoji.allAnimalBird() },
        "animal_mammal" to { Emoji.allAnimalMammal() },
        "animal_amphibian" to { Emoji.allAnimalAmphibian() },
        "plant_other" to { Emoji.allPlantOther() },
        "animal_reptile" to { Emoji.allAnimalReptile() },
    )
