package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAlgeria: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇩🇿",
        description = "flag: Algeria",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-algeria", "algeria-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Algeria.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAlgeria: Emoji get() = _FlagAlgeria

/**
 * Alias to emoji [FlagAlgeria] (Flags: country-flag: flag: Algeria).
*/
public val Emoji.Companion.AlgeriaFlag: Emoji get() = _FlagAlgeria
