package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBermuda: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇲",
        description = "flag: Bermuda",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-bermuda", "bermuda-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Bermuda.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBermuda: Emoji get() = _FlagBermuda

/**
 * Alias to emoji [FlagBermuda] (Flags: country-flag: flag: Bermuda).
*/
public val Emoji.Companion.BermudaFlag: Emoji get() = _FlagBermuda
