package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagIran: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇷",
        description = "flag: Iran",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-iran", "iran-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Iran.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagIran: Emoji get() = _FlagIran

/**
 * Alias to emoji [FlagIran] (Flags: country-flag: flag: Iran).
*/
public val Emoji.Companion.IranFlag: Emoji get() = _FlagIran
