package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagIsleOfMan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇮🇲",
        description = "flag: Isle of Man",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-isle-of-man", "isle-of-man-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Isle of Man.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagIsleOfMan: Emoji get() = _FlagIsleOfMan

/**
 * Alias to emoji [FlagIsleOfMan] (Flags: country-flag: flag: Isle of Man).
*/
public val Emoji.Companion.IsleOfManFlag: Emoji get() = _FlagIsleOfMan
