package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagNiger: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇳🇪",
        description = "flag: Niger",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-niger", "niger-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Niger.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagNiger: Emoji get() = _FlagNiger

/**
 * Alias to emoji [FlagNiger] (Flags: country-flag: flag: Niger).
*/
public val Emoji.Companion.NigerFlag: Emoji get() = _FlagNiger
