package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagTanzania: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇹🇿",
        description = "flag: Tanzania",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-tanzania", "tanzania-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Tanzania.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagTanzania: Emoji get() = _FlagTanzania

/**
 * Alias to emoji [FlagTanzania] (Flags: country-flag: flag: Tanzania).
*/
public val Emoji.Companion.TanzaniaFlag: Emoji get() = _FlagTanzania
