package org.kodein.emoji.objects.science

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllScience() {
    add(intArrayOf(0x2697, 0xfe0f), _Alembic)
    add(intArrayOf(0x2697), _Alembic)
    add(intArrayOf(0x1f9eb), _PetriDish)
    add(intArrayOf(0x1f9ea), _TestTube)
    add(intArrayOf(0x1f9ec), _Dna)
    add(intArrayOf(0x1f52d), _Telescope)
    add(intArrayOf(0x1f52c), _Microscope)
    add(intArrayOf(0x1f4e1), _SatelliteAntenna)
}

internal fun MutableList<Emoji>.addAllScience() {
    add(_Alembic)
    add(_PetriDish)
    add(_TestTube)
    add(_Dna)
    add(_Telescope)
    add(_Microscope)
    add(_SatelliteAntenna)
}

/**
 * All Emoji of the Objects: science subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allScience(): List<Emoji> =
    ArrayList<Emoji>(7).apply { addAllScience() }
