package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonGettingHaircut: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "💇",
        description = "person getting haircut",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-getting-haircut", "haircut"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-activity: person getting haircut.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonGettingHaircut: SkinTone1Emoji get() = _PersonGettingHaircut

/**
 * Alias to emoji [PersonGettingHaircut] (People & Body: person-activity: person getting haircut).
*/
public val Emoji.Companion.Haircut: SkinTone1Emoji get() = _PersonGettingHaircut
