package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _HealthWorker: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🧑‍⚕️",
        description = "health worker",
        unicodeVersion = UnicodeVersion(12, 1),
        aliases = listOf("health-worker", "doctor", "nurse"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: health worker.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HealthWorker: SkinTone1Emoji get() = _HealthWorker

/**
 * Alias to emoji [HealthWorker] (People & Body: person-role: health worker).
*/
public val Emoji.Companion.Doctor: SkinTone1Emoji get() = _HealthWorker

/**
 * Alias to emoji [HealthWorker] (People & Body: person-role: health worker).
*/
public val Emoji.Companion.Nurse: SkinTone1Emoji get() = _HealthWorker
