package org.kodein.emoji.people_body.person_role

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonWithVeil: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👰",
        description = "person with veil",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-with-veil", "veil"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-role: person with veil.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonWithVeil: SkinTone1Emoji get() = _PersonWithVeil

/**
 * Alias to emoji [PersonWithVeil] (People & Body: person-role: person with veil).
*/
public val Emoji.Companion.Veil: SkinTone1Emoji get() = _PersonWithVeil
