package org.kodein.emoji.smileys_emotion.face_glasses

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceGlasses() {
    add(intArrayOf(0x1f9d0), _FaceWithMonocle)
    add(intArrayOf(0x1f913), _NerdFace)
    add(intArrayOf(0x1f60e), _SmilingFaceWithSunglasses)
}

internal fun MutableList<Emoji>.addAllFaceGlasses() {
    add(_FaceWithMonocle)
    add(_NerdFace)
    add(_SmilingFaceWithSunglasses)
}

/**
 * All Emoji of the Smileys & Emotion: face-glasses subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFaceGlasses(): List<Emoji> =
    ArrayList<Emoji>(3).apply { addAllFaceGlasses() }
