package org.kodein.emoji.smileys_emotion.face_hand

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FaceWithPeekingEye: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🫣",
        description = "face with peeking eye",
        unicodeVersion = UnicodeVersion(14, 0),
        aliases = listOf("face-with-peeking-eye", "peeking"),
        emoticons = listOf("(*/。＼)"),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: face-hand: face with peeking eye.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FaceWithPeekingEye: Emoji get() = _FaceWithPeekingEye

/**
 * Alias to emoji [FaceWithPeekingEye] (Smileys & Emotion: face-hand: face with peeking eye).
*/
public val Emoji.Companion.Peeking: Emoji get() = _FaceWithPeekingEye
