package org.kodein.emoji.smileys_emotion.face_negative

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllFaceNegative() {
    add(intArrayOf(0x1f624), _FaceWithSteamFromNose)
    add(intArrayOf(0x1f620), _AngryFace)
    add(intArrayOf(0x1f621), _EnragedFace)
    add(intArrayOf(0x1f92c), _FaceWithSymbolsOnMouth)
    add(intArrayOf(0x1f608), _SmilingFaceWithHorns)
    add(intArrayOf(0x1f47f), _AngryFaceWithHorns)
    add(intArrayOf(0x2620, 0xfe0f), _SkullAndCrossbones)
    add(intArrayOf(0x2620), _SkullAndCrossbones)
    add(intArrayOf(0x1f480), _Skull)
}

internal fun MutableList<Emoji>.addAllFaceNegative() {
    add(_FaceWithSteamFromNose)
    add(_AngryFace)
    add(_EnragedFace)
    add(_FaceWithSymbolsOnMouth)
    add(_SmilingFaceWithHorns)
    add(_AngryFaceWithHorns)
    add(_SkullAndCrossbones)
    add(_Skull)
}

/**
 * All Emoji of the Smileys & Emotion: face-negative subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allFaceNegative(): List<Emoji> =
    ArrayList<Emoji>(8).apply { addAllFaceNegative() }
