package org.kodein.emoji.symbols.alphanum

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _JapaneseBargainButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🉐",
        description = "Japanese “bargain” button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("japanese-bargain-button", "bargain"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: alphanum: Japanese “bargain” button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.JapaneseBargainButton: Emoji get() = _JapaneseBargainButton

/**
 * Alias to emoji [JapaneseBargainButton] (Symbols: alphanum: Japanese “bargain” button).
*/
public val Emoji.Companion.Bargain: Emoji get() = _JapaneseBargainButton
