package org.kodein.emoji.symbols.arrow

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _UpDownArrow: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "↕️",
        description = "up-down arrow",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("up-down-arrow", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: arrow: up-down arrow.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.UpDownArrow: Emoji get() = _UpDownArrow
