package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _SmallBlueDiamond: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔹",
        description = "small blue diamond",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("small-blue-diamond", "blue-diamond-small"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Symbols: geometric: small blue diamond.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.SmallBlueDiamond: Emoji get() = _SmallBlueDiamond

/**
 * Alias to emoji [SmallBlueDiamond] (Symbols: geometric: small blue diamond).
*/
public val Emoji.Companion.BlueDiamondSmall: Emoji get() = _SmallBlueDiamond
