package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CheckMarkButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✅",
        description = "check mark button",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("check-mark-button", "check-mark-green"),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Symbols: other-symbol: check mark button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CheckMarkButton: Emoji get() = _CheckMarkButton

/**
 * Alias to emoji [CheckMarkButton] (Symbols: other-symbol: check mark button).
*/
public val Emoji.Companion.CheckMarkGreen: Emoji get() = _CheckMarkButton
