package org.kodein.emoji.activities.sport

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagInHole: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "⛳",
        description = "flag in hole",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-in-hole", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Activities: sport: flag in hole.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagInHole: Emoji get() = _FlagInHole
