package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagOman: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇴🇲",
        description = "flag: Oman",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-oman", "oman-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Oman.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagOman: Emoji get() = _FlagOman

/**
 * Alias to emoji [FlagOman] (Flags: country-flag: flag: Oman).
*/
public val Emoji.Companion.OmanFlag: Emoji get() = _FlagOman
