package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagUnitedKingdom: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇬🇧",
        description = "flag: United Kingdom",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("flag-united-kingdom", "united-kingdom-flag"),
        emoticons = listOf(),
        notoImageRatio = 2.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Flags: country-flag: flag: United Kingdom.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagUnitedKingdom: Emoji get() = _FlagUnitedKingdom

/**
 * Alias to emoji [FlagUnitedKingdom] (Flags: country-flag: flag: United Kingdom).
*/
public val Emoji.Companion.UnitedKingdomFlag: Emoji get() = _FlagUnitedKingdom
