package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CocktailGlass: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🍸",
        description = "cocktail glass",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("cocktail-glass", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Food & Drink: drink: cocktail glass.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CocktailGlass: Emoji get() = _CocktailGlass
