package org.kodein.emoji.objects.tool

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Link: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔗",
        description = "link",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("link", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Objects: tool: link.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Link: Emoji get() = _Link
