package org.kodein.emoji.people_body.hand_single_finger

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _BackhandIndexPointingLeft: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "👈",
        description = "backhand index pointing left",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("backhand-index-pointing-left", "point-left"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: hand-single-finger: backhand index pointing left.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.BackhandIndexPointingLeft: SkinTone1Emoji get() = _BackhandIndexPointingLeft

/**
 * Alias to emoji [BackhandIndexPointingLeft] (People & Body: hand-single-finger: backhand index pointing left).
*/
public val Emoji.Companion.PointLeft: SkinTone1Emoji get() = _BackhandIndexPointingLeft
