package org.kodein.emoji.people_body.person_activity

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _PeopleWithBunnyEars: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👯",
        description = "people with bunny ears",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("people-with-bunny-ears", "bunny-ears"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji People & Body: person-activity: people with bunny ears.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PeopleWithBunnyEars: Emoji get() = _PeopleWithBunnyEars

/**
 * Alias to emoji [PeopleWithBunnyEars] (People & Body: person-activity: people with bunny ears).
*/
public val Emoji.Companion.BunnyEars: Emoji get() = _PeopleWithBunnyEars
