package org.kodein.emoji.symbols.av_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _RepeatButton: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🔁",
        description = "repeat button",
        unicodeVersion = UnicodeVersion(1, 0),
        aliases = listOf("repeat-button", "repeat"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: av-symbol: repeat button.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.RepeatButton: Emoji get() = _RepeatButton

/**
 * Alias to emoji [RepeatButton] (Symbols: av-symbol: repeat button).
*/
public val Emoji.Companion.Repeat: Emoji get() = _RepeatButton
