package org.kodein.emoji.symbols.geometric

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _DiamondWithADot: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💠",
        description = "diamond with a dot",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("diamond-with-a-dot", "diamond-jewel"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: geometric: diamond with a dot.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.DiamondWithADot: Emoji get() = _DiamondWithADot

/**
 * Alias to emoji [DiamondWithADot] (Symbols: geometric: diamond with a dot).
*/
public val Emoji.Companion.DiamondJewel: Emoji get() = _DiamondWithADot
