package org.kodein.emoji.symbols.other_symbol

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _EightPointedStar: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "✴️",
        description = "eight-pointed star",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("eight-pointed-star", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Symbols: other-symbol: eight-pointed star.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.EightPointedStar: Emoji get() = _EightPointedStar
