package org.kodein.emoji.travel_places.time

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _ThreeOclock: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🕒",
        description = "three o’clock",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("three-oclock", "three-o-clock"),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: time: three o’clock.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.ThreeOclock: Emoji get() = _ThreeOclock

/**
 * Alias to emoji [ThreeOclock] (Travel & Places: time: three o’clock).
*/
public val Emoji.Companion.ThreeOClock: Emoji get() = _ThreeOclock
