package org.kodein.emoji.travel_places.transport_ground

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _HorizontalTrafficLight: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🚥",
        description = "horizontal traffic light",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("horizontal-traffic-light", ),
        emoticons = listOf(),
        notoImageRatio = 1.0f,
        notoAnimationRatio = 0.0f,
    ),
)

/**
 * Emoji Travel & Places: transport-ground: horizontal traffic light.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.HorizontalTrafficLight: Emoji get() = _HorizontalTrafficLight
