package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagAzerbaijan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇦🇿",
        description = "flag: Azerbaijan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-azerbaijan", "azerbaijan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Azerbaijan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagAzerbaijan: Emoji get() = _FlagAzerbaijan

/**
 * Alias to emoji [FlagAzerbaijan] (Flags: country-flag: flag: Azerbaijan).
*/
public val Emoji.Companion.AzerbaijanFlag: Emoji get() = _FlagAzerbaijan
