package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBelgium: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇪",
        description = "flag: Belgium",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-belgium", "belgium-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Belgium.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBelgium: Emoji get() = _FlagBelgium

/**
 * Alias to emoji [FlagBelgium] (Flags: country-flag: flag: Belgium).
*/
public val Emoji.Companion.BelgiumFlag: Emoji get() = _FlagBelgium
