package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagBenin: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇧🇯",
        description = "flag: Benin",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-benin", "benin-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Benin.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagBenin: Emoji get() = _FlagBenin

/**
 * Alias to emoji [FlagBenin] (Flags: country-flag: flag: Benin).
*/
public val Emoji.Companion.BeninFlag: Emoji get() = _FlagBenin
