package org.kodein.emoji.flags.country_flag

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FlagSudan: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🇸🇩",
        description = "flag: Sudan",
        unicodeVersion = UnicodeVersion(2, 0),
        aliases = listOf("flag-sudan", "sudan-flag"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Flags: country-flag: flag: Sudan.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FlagSudan: Emoji get() = _FlagSudan

/**
 * Alias to emoji [FlagSudan] (Flags: country-flag: flag: Sudan).
*/
public val Emoji.Companion.SudanFlag: Emoji get() = _FlagSudan
