package org.kodein.emoji.food_drink.drink

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _GlassOfMilk: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🥛",
        description = "glass of milk",
        unicodeVersion = UnicodeVersion(3, 0),
        aliases = listOf("glass-of-milk", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Food & Drink: drink: glass of milk.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.GlassOfMilk: Emoji get() = _GlassOfMilk
