package org.kodein.emoji.objects.clothing

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WomansSandal: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "👡",
        description = "woman’s sandal",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("womans-sandal", "sandal"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: clothing: woman’s sandal.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WomansSandal: Emoji get() = _WomansSandal

/**
 * Alias to emoji [WomansSandal] (Objects: clothing: woman’s sandal).
*/
public val Emoji.Companion.Sandal: Emoji get() = _WomansSandal
