package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _Laptop: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "💻",
        description = "laptop",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("laptop", "laptop-computer"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: computer: laptop.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.Laptop: Emoji get() = _Laptop

/**
 * Alias to emoji [Laptop] (Objects: computer: laptop).
*/
public val Emoji.Companion.LaptopComputer: Emoji get() = _Laptop
