package org.kodein.emoji.objects.computer

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllComputer() {
    add(intArrayOf(0x1f50c), _ElectricPlug)
    add(intArrayOf(0x1f50b), _Battery)
    add(intArrayOf(0x1faab), _LowBattery)
    add(intArrayOf(0x1f5b2, 0xfe0f), _Trackball)
    add(intArrayOf(0x1f5b2), _Trackball)
    add(intArrayOf(0x1f4bd), _ComputerDisk)
    add(intArrayOf(0x1f4be), _FloppyDisk)
    add(intArrayOf(0x1f4bf), _OpticalDisk)
    add(intArrayOf(0x1f4c0), _Dvd)
    add(intArrayOf(0x1f5a5, 0xfe0f), _DesktopComputer)
    add(intArrayOf(0x1f5a5), _DesktopComputer)
    add(intArrayOf(0x1f4bb), _Laptop)
    add(intArrayOf(0x2328, 0xfe0f), _Keyboard)
    add(intArrayOf(0x2328), _Keyboard)
    add(intArrayOf(0x1f5a8, 0xfe0f), _Printer)
    add(intArrayOf(0x1f5a8), _Printer)
    add(intArrayOf(0x1f5b1, 0xfe0f), _ComputerMouse)
    add(intArrayOf(0x1f5b1), _ComputerMouse)
    add(intArrayOf(0x1f9ee), _Abacus)
}

internal fun MutableList<Emoji>.addAllComputer() {
    add(_ElectricPlug)
    add(_Battery)
    add(_LowBattery)
    add(_Trackball)
    add(_ComputerDisk)
    add(_FloppyDisk)
    add(_OpticalDisk)
    add(_Dvd)
    add(_DesktopComputer)
    add(_Laptop)
    add(_Keyboard)
    add(_Printer)
    add(_ComputerMouse)
    add(_Abacus)
}

/**
 * All Emoji of the Objects: computer subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allComputer(): List<Emoji> =
    ArrayList<Emoji>(14).apply { addAllComputer() }
