package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _FilmFrames: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎞️",
        description = "film frames",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("film-frames", "film"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: light & video: film frames.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.FilmFrames: Emoji get() = _FilmFrames

/**
 * Alias to emoji [FilmFrames] (Objects: light & video: film frames).
*/
public val Emoji.Companion.Film: Emoji get() = _FilmFrames
