package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _MovieCamera: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🎥",
        description = "movie camera",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("movie-camera", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: light & video: movie camera.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.MovieCamera: Emoji get() = _MovieCamera
