package org.kodein.emoji.objects.light_video

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllLightVideo() {
    add(intArrayOf(0x1fa94), _DiyaLamp)
    add(intArrayOf(0x1f4f7), _Camera)
    add(intArrayOf(0x1f4f8), _CameraWithFlash)
    add(intArrayOf(0x1f4fa), _Television)
    add(intArrayOf(0x1f4fc), _Videocassette)
    add(intArrayOf(0x1f4f9), _VideoCamera)
    add(intArrayOf(0x1f4fd, 0xfe0f), _FilmProjector)
    add(intArrayOf(0x1f4fd), _FilmProjector)
    add(intArrayOf(0x1f3a5), _MovieCamera)
    add(intArrayOf(0x1f39e, 0xfe0f), _FilmFrames)
    add(intArrayOf(0x1f39e), _FilmFrames)
    add(intArrayOf(0x1f3ac), _ClapperBoard)
    add(intArrayOf(0x1f56f, 0xfe0f), _Candle)
    add(intArrayOf(0x1f56f), _Candle)
    add(intArrayOf(0x1f4a1), _LightBulb)
    add(intArrayOf(0x1f526), _Flashlight)
    add(intArrayOf(0x1f3ee), _RedPaperLantern)
    add(intArrayOf(0x1f50d), _MagnifyingGlassTiltedLeft)
    add(intArrayOf(0x1f50e), _MagnifyingGlassTiltedRight)
}

internal fun MutableList<Emoji>.addAllLightVideo() {
    add(_DiyaLamp)
    add(_Camera)
    add(_CameraWithFlash)
    add(_Television)
    add(_Videocassette)
    add(_VideoCamera)
    add(_FilmProjector)
    add(_MovieCamera)
    add(_FilmFrames)
    add(_ClapperBoard)
    add(_Candle)
    add(_LightBulb)
    add(_Flashlight)
    add(_RedPaperLantern)
    add(_MagnifyingGlassTiltedLeft)
    add(_MagnifyingGlassTiltedRight)
}

/**
 * All Emoji of the Objects: light & video subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allLightVideo(): List<Emoji> =
    ArrayList<Emoji>(16).apply { addAllLightVideo() }
