package org.kodein.emoji.objects.medical

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.addSt1Variations
import org.kodein.emoji.addSt2Variations


internal fun EmojiFinder.addAllMedical() {
    add(intArrayOf(0x1fa78), _DropOfBlood)
    add(intArrayOf(0x1fa7c), _Crutch)
    add(intArrayOf(0x1f489), _Syringe)
    add(intArrayOf(0x1f48a), _Pill)
    add(intArrayOf(0x1fa79), _AdhesiveBandage)
    add(intArrayOf(0x1fa7a), _Stethoscope)
    add(intArrayOf(0x1fa7b), _XRay)
}

internal fun MutableList<Emoji>.addAllMedical() {
    add(_DropOfBlood)
    add(_Crutch)
    add(_Syringe)
    add(_Pill)
    add(_AdhesiveBandage)
    add(_Stethoscope)
    add(_XRay)
}

/**
 * All Emoji of the Objects: medical subgroup.
 *
 * WARNING: This can be quite heavy to construct.
 * This method should be called in background and its result should be cached.
*/
public fun Emoji.Companion.allMedical(): List<Emoji> =
    ArrayList<Emoji>(7).apply { addAllMedical() }
