package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _CardFileBox: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🗃️",
        description = "card file box",
        unicodeVersion = UnicodeVersion(0, 7),
        aliases = listOf("card-file-box", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: office: card file box.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.CardFileBox: Emoji get() = _CardFileBox
