package org.kodein.emoji.objects.office

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _TearOffCalendar: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "📆",
        description = "tear-off calendar",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("tear-off-calendar", ),
        emoticons = listOf(),
        notoAnimated = false,
    ),
)

/**
 * Emoji Objects: office: tear-off calendar.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.TearOffCalendar: Emoji get() = _TearOffCalendar
