package org.kodein.emoji.people_body.person_gesture

import org.kodein.emoji.Emoji
import org.kodein.emoji.SkinTone1Emoji
import org.kodein.emoji.SkinTone1EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder
import org.kodein.emoji.SkinTone


internal val _PersonBowing: SkinTone1Emoji = SkinTone1EmojiImpl(
    details = Emoji.Details(
        string = "🙇",
        description = "person bowing",
        unicodeVersion = UnicodeVersion(0, 6),
        aliases = listOf("person-bowing", "bow"),
        emoticons = listOf(),
        notoAnimated = false,
    ),
    sk1c = 2,
)

/**
 * Emoji People & Body: person-gesture: person bowing.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.PersonBowing: SkinTone1Emoji get() = _PersonBowing

/**
 * Alias to emoji [PersonBowing] (People & Body: person-gesture: person bowing).
*/
public val Emoji.Companion.Bow: SkinTone1Emoji get() = _PersonBowing
