package org.kodein.emoji.smileys_emotion.heart

import org.kodein.emoji.Emoji
import org.kodein.emoji.EmojiImpl
import org.kodein.emoji.UnicodeVersion
import org.kodein.emoji.EmojiFinder


internal val _WhiteHeart: Emoji = EmojiImpl(
    details = Emoji.Details(
        string = "🤍",
        description = "white heart",
        unicodeVersion = UnicodeVersion(12, 0),
        aliases = listOf("white-heart", ),
        emoticons = listOf(),
        notoAnimated = true,
    ),
)

/**
 * Emoji Smileys & Emotion: heart: white heart.
 *
 * Preferred type is: fully-qualified.
*/
public val Emoji.Companion.WhiteHeart: Emoji get() = _WhiteHeart
